# What is the Windows Performance Toolkit?

The Windows Performance Toolkit (WPT) is a set of tools provided by Microsoft to analyze and improve the performance of Windows operating systems. These tools help you collect, analyze, and visualize performance data, which can be useful for diagnosing issues, and optimizing both system and application performance. WPT is often used by system administrators, developers, and IT professionals who need to troubleshoot but not limited to performance-related issues on Windows.

Windows Performance Toolkit can be downloaded here: https://learn.microsoft.com/en-us/windows-hardware/get-started/adk-install

# Windows Performance Recorder (WPR)

WPR is a tool used for recording system events and various performance data. It can capture data such as CPU usage, disk I/O, memory usage, and more. Once the recording is done, it saves the data in a file with a **.etl** (Event Trace Log) extension.

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/a4afe1f8-0f02-40fc-b6a6-e9d37b710804)

# Windows Performance Analyzer (WPA)

WPA is the tool you use to analyze the **.etl** files generated by WPR. It offers a graphical interface that allows you to drill down into performance data to identify performance issues for example. WPA provides various views and graphs that display different aspects of system performance, such as CPU utilization, disk activity, and so on.

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/9edc0829-4f02-4389-9bec-aad36e11c735)

# What is Event Tracing for Windows (ETW)?

Event Tracing for Windows (ETW) is a powerful tracing facility built into the Windows operating system. It provides a way to instrument, collect, and analyze performance and diagnostic data from various sources, such as applications, kernel-mode drivers, and the operating system itself. ETW allows you to collect execution information, making it a valuable tool for debugging, troubleshooting, and monitoring system behavior.

Not going into much details, since there is a lot of documentation around ETW. However, these are the main concepts that we should know at least on a high-level:

- **Providers:** These are the sources of ETW events. They can be part of the OS kernel, user-mode applications, or drivers.
- **Events:** Providers generate events that contain specific data, like a log entry. These events are categorized and can have different levels of verbosity.
- **Sessions:** These are the mechanisms for collecting events. You can configure sessions to specify which providers to enable, what kind of events to collect, and where to store the collected data.
- **Consumers:** These are applications or services that read and analyze the collected ETW events. The most commonly used consumer is probably the "Windows Performance Analyzer".

Event Tracing for Windows (ETW) supports four type of providers, which can be read here: https://learn.microsoft.com/en-us/windows/win32/etw/about-event-tracing. However, our focus will be mainly on **Manifest-based** providers which are XML files that defines the events that an ETW provider can log. Each event is described with a unique identifier and includes information about what kind of data the event contains.

The manifest describes the metadata for events, which includes:

- **Event ID:** A unique identifier for each event.
- **Keywords:** Used to group events into categories.
- **Level:** Indicates the severity or verbosity level of the event (e.g., Information, Warning, Error).
- **Task:** Represents a group of related events.
- **Opcode:** Provides additional information about the event's operation.

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/3ce15fdf-16e6-4dad-9363-bafb4fddb4f7)


# What are ETL files?

ETL files which stands for Event Trace Log files are part of ETW. These files are used to store information about various system and application behaviors, primarily for the purpose of troubleshooting and debugging. The core of an ETL file is the trace data, which comprises events logged during a tracing session. These events can include a wide array of information depending on the providers that were enabled for the trace.

The content of ETL files are in a binary format, which is not directly readable by humans. We need to use tools like Windows Performance Analyzer (WPA) to interpret and visualize the data.

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/0471c54d-bc9a-44b8-b92e-49b287f87630)
